﻿#include  "StdAfx.h"

#include  <szArchiveDetector.hpp>
#include  <szCodecManager.hpp>
#include  <7zip/UI/Common/LoadCodecs.h>

SZ_NS_BEG(szpp)

ArchiveHandler *ArchiveDetector::FindHandlerFromExtension(const szstring &extension)
{
  return CodecManager::GetHandler(CodecManager::GetCodecs()->FindFormatForExtension(extension.c_str())).Clone();
}

ArchiveHandler *ArchiveDetector::FindHandlerFromStream(IInStream *stream)
{
  return 0;
}

ArchiveHandler *ArchiveDetector::FindHandlerFromFile(const szstring &fileName)
{
  return 0;
}

ArchiveHandler *ArchiveDetector::FindHandlerFromName(const szstring &name)
{
  return CodecManager::GetHandler(CodecManager::GetCodecs()->FindFormatForArchiveType(name.c_str())).Clone();
}

ArchiveHandler *ArchiveDetector::FindHandlerFromFormat(ArchiveFormat format)
{
  const CLSID clsid = { 0x23170F69, 0x40C1, 0x278A, { 0x10, 0x00, 0x00, 0x01, 0x10, static_cast<u08>(format), 0x00, 0x00 } };
  CCodecs *codecs = CodecManager::GetCodecs();
  for (int i = 0; i < codecs->Formats.Size(); ++i)
  {
    const CArcInfoEx &ai = codecs->Formats[i];
    if (0 == memcmp(&clsid, &ai.ClassID, sizeof(clsid)))
      return CodecManager::GetHandler(i).Clone();
  }
  return 0;
}

SZ_NS_END(szpp)
